LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
PACKAGE sigdecl IS
  TYPE bus_type IS ARRAY(0 to 7) OF std_logic;

  SIGNAL vcc    : std_logic := '1';
  SIGNAL ground : std_logic := '0';

  FUNCTION magic_function( a : IN bus_type) RETURN bus_type;

END sigdecl;

USE WORK.sigdecl.ALL;
LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY board_design is
  PORT( data_in : IN bus_type;
        data_out : OUT bus_type);

  SIGNAL sys_clk : std_logic := '1';

END board_design;

ARCHITECTURE data_flow OF board_design IS
  SIGNAL int_bus : bus_type;
  CONSTANT disconnect_value : bus_type
    := ('X', 'X', 'X', 'X', 'X', 'X', 'X', 'X');
BEGIN
  int_bus <= data_in WHEN sys_clk = '1'
    ELSE int_bus;

  data_out <= magic_function(int_bus) WHEN sys_clk = '0'
    ELSE disconnect_value;

  sys_clk <= NOT(sys_clk) after 50 ns;
END data_flow;


